% =========================================================================
%   Praktikum MATLAB/Simulink I
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

% Versuch 3.1
% Versuchsdurchfhrung 3.1.6 Vergleich der Berechnungsmethoden

%%  Definition der Konstanten


%% Analytische Lsung (Teil I)
T = 15; %max Zeit
[x_ana_1, t_ana_1] = AnalytischeLoesung(omega, Parameter, T(1), P1, P2);

%% Numerische Lsung (Teil II)
x0 = [0 0].'; %Anfangsbedingungen
T = 15; %max Zeit
[x_num_11, t_num_11] = NumerischeLoesung(T, x0, 1);
[x_num_21, t_num_21] = NumerischeLoesung(T, x0, 2);

%% Diskrete Lsung (Teil III)
N = 30; %30 Schritte
T0 = 0.5; % Definition der Schrittweiten
[x_dis_1, t_dis_1] = DiskreteLoesung(Parameter, omega, N, T0);

%% Plotten der Ergebnisse
figure()
plot(t_ana_1, x_ana_1, '--', t_dis_1, x_dis_1, ':', ...
        t_num_11, x_num_11, ':', t_num_21, x_num_21, '--', 'linewidth', 2);
legend('Analytisch', 'Diskret', ...
            'Numerisch; Explizit', 'Numerisch; Implizit');
xlabel('t / s');
ylabel('x(t) / m');
grid on

